#!/usr/bin/env python

import json
import random
import sys
import argparse


def random_bounding_box():
    x0 = random.random()
    x1 = random.random()
    if x1 < x0:
        x0, x1 = x1, x0

    y0 = random.random()
    y1 = random.random()
    if y1 < y0:
        y0, y1 = y1, y0

    label = random.choice(
        ["name", "handwritten"])

    return {"x0": x0, "y0": y0, "x1": x1, "y1": y1, "label": label}


def process_image(fn):
    bounding_boxes = []
    for i in range(random.randrange(10)):
        bounding_boxes.append(random_bounding_box())

    return {"id": fn, "bounding_boxes": bounding_boxes}


if __name__ == "__main__":
    parser = argparse.ArgumentParser(
        description=
        "Sample implementation for task 1. This script creates a random annotation for task 1."
    )
    parser.add_argument("id_list",
                        type=argparse.FileType("r"),
                        help="List of id to create sample annotations for.")

    args = parser.parse_args()

    for s in args.id_list:
        img_fn = s.strip()
        res = process_image(img_fn)
        print(json.dumps(res))
